const vscode = require('vscode');

/**
 * @param {vscode.ExtensionContext} context
 */
function activate(context) {
    let enablePlugin = vscode.commands.registerCommand('cocopilot.enablePlugin', async function () {
        const config = vscode.workspace.getConfiguration();
        let advancedConfig = config.get('github.copilot.advanced');
        if (!advancedConfig) {
            advancedConfig = {};
        }

        advancedConfig['authProvider'] = 'github-enterprise';
        advancedConfig['debug.overrideChatEngine'] = 'gpt-4';
        config.update('github.copilot.advanced', advancedConfig, vscode.ConfigurationTarget.Global);
        config.update('github-enterprise.uri', 'https://cocopilot.org', vscode.ConfigurationTarget.Global);

        const result = await vscode.window.showInformationMessage('CoCopilot is ready for takeoff! Reload now?', 'Yes', 'No');
        if (result === 'Yes') {
            vscode.commands.executeCommand('workbench.action.reloadWindow');
        }
    });

    let disablePlugin = vscode.commands.registerCommand('cocopilot.disablePlugin', async function () {
        const config = vscode.workspace.getConfiguration();
        let advancedConfig = config.get('github.copilot.advanced');
        if (advancedConfig) {
            advancedConfig['authProvider'] = undefined;
            advancedConfig['debug.overrideChatEngine'] = undefined;
            config.update('github.copilot.advanced', advancedConfig, vscode.ConfigurationTarget.Global);
        }

        config.update('github-enterprise.uri', undefined, vscode.ConfigurationTarget.Global);

        const result = await vscode.window.showInformationMessage('CoCopilot is grounded! Reload now?', 'Yes', 'No');
        if (result === 'Yes') {
            vscode.commands.executeCommand('workbench.action.reloadWindow');
        }
    });

    let enableGPT4Chat = vscode.commands.registerCommand('cocopilot.enableGPT4Chat', async function () {
        const config = vscode.workspace.getConfiguration();
        let advancedConfig = config.get('github.copilot.advanced');
        if (!advancedConfig) {
            advancedConfig = {};
        }

        advancedConfig['debug.overrideChatEngine'] = 'gpt-4';
        config.update('github.copilot.advanced', advancedConfig, vscode.ConfigurationTarget.Global);

        const result = await vscode.window.showInformationMessage('Copilot Chat is ready for takeoff! Reload now?', 'Yes', 'No');
        if (result === 'Yes') {
            vscode.commands.executeCommand('workbench.action.reloadWindow');
        }
    });

    context.subscriptions.push(enablePlugin);
    context.subscriptions.push(disablePlugin);
    context.subscriptions.push(enableGPT4Chat);
}

function deactivate() {
}

module.exports = {
    activate,
    deactivate
}
